// ================= INTERACTIVE FEATURES (handles mobile menu and dark mode toggle - no need to change anything here!) =================

(function () {
  const root = document.documentElement;
  const header = document.getElementById('sticky-nav');
  const toggle = document.querySelector('.nav-toggle');
  const darkBtn = document.querySelector('.nav-dark');

  if (toggle && header) {
    toggle.addEventListener('click', () => {
      const isOpen = header.classList.toggle('nav-open');
      toggle.setAttribute('aria-expanded', String(isOpen));
    });
  }

  const STORAGE_KEY = 'template-theme';
  const saved = localStorage.getItem(STORAGE_KEY);

  if (!saved) {
    const prefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
    if (prefersDark) root.classList.add('theme-dark');
  } else if (saved === 'dark') {
    root.classList.add('theme-dark');
  }

  function syncDarkButton() {
    if (!darkBtn) return;
    const isDark = root.classList.contains('theme-dark');
    darkBtn.setAttribute('aria-pressed', String(isDark));
    darkBtn.title = isDark ? 'Switch to light mode' : 'Switch to dark mode';

    const icon = darkBtn.querySelector('i');
    if (!icon) return;

    icon.classList.remove('fa-moon', 'fa-sun');
    icon.classList.add(isDark ? 'fa-sun' : 'fa-moon');
  }

  if (darkBtn) {
    darkBtn.addEventListener('click', () => {
      root.classList.add('theme-transition');
      const isDark = root.classList.toggle('theme-dark');
      localStorage.setItem(STORAGE_KEY, isDark ? 'dark' : 'light');
      syncDarkButton();

      setTimeout(() => {
        root.classList.remove('theme-transition');
      }, 100);
    });
    syncDarkButton();
  }
})();

// ================= AUTOMATICALLY HIGHLIGHT ACTIVE LINK (no need to change this!) =================
(function () {
  const current = window.location.pathname.split('/').pop() || 'index.php';
  const links = document.querySelectorAll('.nav-links a');

  links.forEach(link => {
    const href = link.getAttribute('href');
    if (href === current) {
      link.classList.add('active');
    }
  });
})();
// ================= MOBILE DROPDOWN TOGGLE (handles click/tap on mobile) =================
(function () {
  const dropdownLinks = document.querySelectorAll('.nav-item-has-children > a');

  dropdownLinks.forEach(link => {
    link.addEventListener('click', (e) => {
      // Only run on mobile (matches css media query)
      if (window.innerWidth <= 900) {
        e.preventDefault();
        const parent = link.parentElement;

        // Close other dropdowns
        dropdownLinks.forEach(otherLink => {
          const otherParent = otherLink.parentElement;
          if (otherParent !== parent) {
            otherParent.classList.remove('is-open');
          }
        });

        // Toggle current dropdown
        parent.classList.toggle('is-open');
      }
    });
  });
})();
